from matplotlib import pyplot as plt
import pandas as pd

plt.style.use("seaborn")

# scatter plots - great for displaying correlation between
# two sets of data

x = [5,7,8,5,6,7,9,2,3,4,4,4,2,6,3,6,8,6,4,1]
y = [7,4,3,9,1,3,2,5,2,4,8,7,1,6,4,9,7,7,5,1]

# plot scatter plot (try x marker)
# plt.scatter(x,y, s=100, c='green', marker='o', edgecolor='black', linewidth=1, alpha=0.75)

# add multiple colors and sizes, so we add aditional data sets to our plots
colors = [7,5,9,7,5,7,2,5,3,7,1,2,8,1,9,2,5,6,7,5] # colors correspond to types of answers for each point
# plt.scatter(x,y, s=100, c=colors, marker='o', edgecolor='black', 
#               linewidth=1, alpha=0.75, cmap='Greens') 
# different shades of green as intensity

# add a colorbar legend to express satisfaction
# cbar = plt.colorbar()
# cbar.set_label('Satisfaction level')

# we can also change sizes easily
sizes = [209, 486, 381, 255, 191, 315, 185, 228, 174,
         538, 239, 394, 399, 153, 273, 293, 436, 501, 397, 539]
plt.scatter(x,y, s=sizes, c=colors, marker='o', edgecolor='black', 
                linewidth=1, alpha=0.75, cmap='Greens') 

# add a colorbar legend to express satisfaction
cbar = plt.colorbar()
cbar.set_label('Satisfaction level')

plt.tight_layout()
plt.show()

